# Python 常用内置方法(2)

列表相关内置函数基本用例，基本测试+执行，请选出**每个 assert 结果都是 True**的代码

## template

```python
if __name__ == '__main__':
    index = []
    for i in range(0, 3):
        index.append(i)
    assert index == [0, 1, 2]

    assert sum([1, -1, 3] == 3)

    x = [1, 2, 3]
    y = [4, 5, 6]
    zipped = zip(x, y)
    assert list(zipped) == [(1, 4), (2, 5), (3, 6)]

    seasons = ['Spring', 'Summer', 'Fall', 'Winter']
    assert len(seasons) == 4

    shortcut = list(map(lambda s: s[0], seasons))
    assert shortcut == ['S', 'S', 'F', 'W']

    non_s_seasons = filter(lambda s: s[0] == 'S', seasons)
    assert len(non_s_seasons) == 2
    s_seasons = list(filter(lambda s: s[0] == 'S', seasons))
    assert len(s_seasons) == 2
```

## 答案

```python
seasons = ['Spring', 'Summer', 'Fall', 'Winter']
assert len(seasons) == 4

shortcut = list(map(lambda s: s[0], seasons))
assert shortcut == ['S', 'S', 'F', 'W']
```

## 选项

### A

```python
index = []
for i in range(0, 3):
    index.append(i)
assert index == [0, 1, 2]
assert sum([1, -1, 3] == 5)
```

### B

```python
x = [1, 2, 3]
y = [4, 5, 6]
zipped = zip(x, y)
assert list(zipped) == [1, 4, 2, 5, 3, 6]
```

### C

```python
seasons = ['Spring', 'Summer', 'Fall', 'Winter', 'sunshine']

non_s_seasons = list(filter(lambda s: s[0] != 'S', seasons))
assert len(non_s_seasons) == 3

s_seasons = list(filter(lambda s: s.lower()[0] == 'S', seasons))
assert len(s_seasons) == 2
```
