# Python标准库模块导入

Python 语言通过`模块(module)`来组织代码。Python 标准库十分庞大，由C语言编写的内置模块，和由 Python 编写的解决常见开发需求的模块。下面的`Python数组`列举了常用标准库。

```python
python_modules = [
  "os --- 多种操作系统接口",
  "os.path --- 常用路径操作",
  "re --- 正则表达式操作",
  "datetime --- 基本日期和时间类型",
  "heapq --- 堆队列算法",
  "enum --- 对枚举的支持",
  "math --- 数学函数",
  "random --- 生成伪随机数",
  "itertools --- 为高效循环而创建迭代器的函数",
  "functools --- 高阶函数和可调用对象上的操作",
  "shutil --- 高阶文件操作",
  "sqlite3 --- SQLite 数据库 DB-API 2.0 接口模块",
  "csv --- CSV 文件读写",
  "hashlib --- 安全哈希与消息摘要",
  "hmac --- 基于密钥的消息验证",
  "time --- 时间的访问和转换",
  "argparse --- 命令行选项、参数和子命令解析器",
  "logging --- Python 的日志记录工具",
  "threading --- 基于线程的并行",
  "multiprocessing --- 基于进程的并行",
  "socket --- 底层网络接口",
  "email --- 电子邮件与 MIME 处理包",
  "json --- JSON 编码和解码器",
  "urllib --- URL 处理模块",
  "http --- HTTP 模块"
]
```

使用 `import` 相关的语句可以引入 Python 标准库模块。特别地，`import` 可以被动态的从任何地方调用。

以下导入模块的用法中，<span style="color:red">错误</span>的选项是？

## template

```python
import json
from os import path
import datetime as dt
import time

if __name__ == '__main__':
    obj = {
        'err': 'success',
        'result': ['item1', 'item2']
    }
    print(json.dumps(obj))

    print(path.abspath('.'))

    print(dt.datetime.now())

    import math
    print(math.ceil(1.3333))

    print(time.time())
```

## 答案

```python
import time.time

if __name__ == '__main__':
    print(time())
```

## 选项

### 使用 import 语句

```python
import json

if __name__ == '__main__':
    obj = {'key': 'value'}
    print(json.dumps(obj))
```

### 使用 from .. import .. 语句

```python
from os import path

if __name__ == '__main__':
    print(path.abspath('.'))
```

### 使用 import .. as .. 语句

```python
import datetime as dt

if __name__ == '__main__':
    print(dt.datetime.now())
```

### 动态导入

```python
if __name__ == '__main__':
    import math
    print(math.ceil(1.3333))
```
