import unittest

from parsec.state import BasicState

from skill_tree.excercises.market_math import processor
import skill_tree.excercises.markdown as mk


def math_processor(context):
    """ math(str)->str
对文本内容预处理，将公式标记为前端可展示的 html。
    """
    md = context
    new_md = []
    math_ctx = {
        "enter": False,
        "chars": []
    }

    count = len(md)
    i = 0
    while i < count:
        c = md[i]
        if c == '$':
            if math_ctx['enter']:
                j = 0
                chars = math_ctx['chars']
                length = len(chars)
                while j < length:
                    cc = chars[j]
                    if cc == '_':
                        next_c = chars[j + 1]
                        if next_c == '{':
                            subs = []
                            cursor = 2
                            next_c = chars[j + cursor]
                            while next_c != '}':
                                subs.append(next_c)
                                cursor += 1
                                next_c = chars[j + cursor]

                            sub = ''.join(subs)
                            new_md.append(f'<sub>{sub}</sub>')
                            j += cursor
                        else:
                            new_md.append(f'<sub>{next_c}</sub>')
                            j += 1
                    elif cc == '^':
                        next_c = chars[j + 1]
                        if next_c == '{':
                            subs = []
                            cursor = 2
                            next_c = chars[j + cursor]
                            while next_c != '}':
                                subs.append(next_c)
                                cursor += 1
                                next_c = chars[j + cursor]

                            sub = ''.join(subs)
                            new_md.append(f'<sup>{sub}</sup>')
                            j += cursor
                        else:
                            new_md.append(f'<sup>{next_c}</sup>')
                            j += 1
                    else:
                        new_md.append(cc)
                    j += 1

                math_ctx['enter'] = False
                math_ctx['chars'] = []
            else:
                math_ctx['enter'] = True
                math_ctx['chars'] = []
        else:
            if math_ctx['enter']:
                math_ctx['chars'].append(c)
            else:
                new_md.append(c)
        i += 1
    return "".join(new_md)

data = """
# Hello World

以下 `Hello World` 程序中，能够正确输出内容的是：

## 答案

```java
package app;

public class App {
    public static void main(String[] args){
        System.out.println("Hello World");
    }
}
```

## 选项

### B

```java
package app;

public class App {
    public int main(){
        System.out.printf("Hello World");
        return 0;
    }
}
```

### C

```java
package app;

public class App {
    public static void main(String[] args){
        println("Hello World");
    }
}
```

### D

```java
package app;
import stdout

public class App {
    public int main(){
        print("Hello World\n");
        return 0;
    }
}

```

"""


class MarkdownTestCase(unittest.TestCase):
    def test_basic(self):
        state = BasicState(data.strip())
        doc = mk.parse(state)
        self.assertEqual(doc.title, "Hello World")
        self.assertEqual(len(doc.options), 3)
        self.assertEqual(doc.description[0].source.strip(), """以下 `Hello World` 程序中，能够正确输出内容的是：""")
        self.assertEqual(doc.answer[0].language, "java")
        self.assertEqual(doc.answer[0].source, """package app;

public class App {
    public static void main(String[] args){
        System.out.println("Hello World");
    }
}""")
        self.assertEqual(doc.options[0].paras[0].language, "java")
        self.assertEqual(doc.options[0].paras[0].source, """package app;

public class App {
    public int main(){
        System.out.printf("Hello World");
        return 0;
    }
}""")
        self.assertEqual(doc.options[1].paras[0].language, "java")
        self.assertEqual(doc.options[1].paras[0].source, """package app;

public class App {
    public static void main(String[] args){
        println("Hello World");
    }
}""")
        self.assertEqual(doc.options[2].paras[0].language, "java")
        self.assertEqual(doc.options[2].paras[0].source, """package app;
import stdout

public class App {
    public int main(){
        print("Hello World\n");
        return 0;
    }
}
""")


class MathTestCase(unittest.TestCase):

    def test_parse(self):
        data = "$e^{pi}$"
        result = processor(data)
        self.assertEqual(result, math_processor(data))

    def test_pack(self):
        data = "ploy is $e^{pi}$ in plain text"
        result = processor(data)
        self.assertEqual(result, math_processor(data))

    def test_simple(self):
        data = "ploy is $x_0$ in plain text"
        result = processor(data)
        self.assertEqual(result, math_processor(data))

    def test_left(self):
        data = "$x_0$ at start of plain text"
        result = processor(data)
        self.assertEqual(result, math_processor(data))

    def test_right(self):
        data = "ploy is $x_0$"
        result = processor(data)
        self.assertEqual(result, math_processor(data))



