import numpy as np
import cv2

if __name__ == '__main__':
    img_origin = cv2.imread('bird.jpeg', cv2.COLOR_BGR2LAB)

    kernel = np.ones((3, 3), np.uint8)
    img_erosion = cv2.erode(img_origin, kernel, iterations=1)
    img_dilation = cv2.dilate(img_origin, kernel, iterations=1)

    img_all = np.concatenate((img_origin, img_erosion, img_dilation), axis=1)
    cv2.imwrite('bird_erosion_dilation.jpeg', img_all)
    cv2.imshow('img: origin, erosion and dilation', img_all)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
