# 盒式滤波器

图像滤波是在尽可能保留图像细节特征的条件下对目标图像的噪声进行抑制，是常用的图像预处理操作。

平滑滤波也称为低通滤波，可以抑制图像中的灰度突变，使图像变得模糊，是低频增强的空间域滤波技术。

盒式核是最简单的可分离低通滤波器核。盒式核结构简单，模板区域中各像素点的系数相同。

OpenCV 提供了函数 `cv.boxFilter()` 可以实现直方图均衡化。

**函数说明：**

```
cv.boxFilter(src, ddepth, ksize[, dst[, anchor[, normalize[, borderType]]]]) → dst
```



##  答案

```
import cv2 as cv

if __name__ == '__main__':
    img = cv.imread("Lena.png")

    ksize = (5, 5)
    imgBoxFilter = cv.boxFilter(img, -1, ksize=ksize)

    cv.imshow("BoxFilter", imgBoxFilter)
    key = cv.waitKey(0)
```

##  选项

###  卷积核的大小 ksize 是元组 (5,5) 或列表 [5, 5]

```
import cv2 as cv

if __name__ == '__main__':
    img = cv.imread("Lena.png")

    ksize = 5
    imgBoxFilter = cv.boxFilter(img, -1, ksize=ksize)

    cv.imshow("BoxFilter", imgBoxFilter)
    key = cv.waitKey(0)
```

###  遗漏了图像通道深度参数 ddepth（-1 表示与输入图像的类型相同）

```
import cv2 as cv

if __name__ == '__main__':
    img = cv.imread("Lena.png")

    ksize = (5, 5)
    imgBoxFilter = cv.boxFilter(img, ksize=ksize)

    cv.imshow("BoxFilter", imgBoxFilter)
    key = cv.waitKey(0)
```

###  归一化处理错误（默认值 normalize=True 表示进行归一化处理）

```
import cv2 as cv

if __name__ == '__main__':
    img = cv.imread("Lena.png")

    ksize = (5, 5)
    imgBoxFilter = cv.boxFilter(img, -1, ksize=ksize, normalize=False)

    cv.imshow("BoxFilter", imgBoxFilter)
    key = cv.waitKey(0)
```
