import numpy as np
import cv2


if __name__ == '__main__':
    cap = cv2.VideoCapture('birds.mp4')

    width = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
    height = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))
    fps = cap.get(cv2.CAP_PROP_FPS)
    out = cv2.VideoWriter(
        'birds_concat.mp4',
        cv2.VideoWriter_fourcc(*'mp4v'),
        fps,
        (width*2, height)
    )

    i = 0
    while(cap.isOpened()):

        ret, bird_frame = cap.read()
        if bird_frame is None:
            break

        bird_flip_frame = cv2.flip(bird_frame, 0)
        bird_concat_frame = np.concatenate(
            (bird_frame, bird_flip_frame),
            axis=1
        )

        cv2.imshow('bird_concat_frame', bird_concat_frame)
        if i % 10 == 0:
            out.write(bird_concat_frame)
        i += 1
        if cv2.waitKey(1) & 0xFF == ord('q'):
            break

    out.release()
    cap.release()

    cv2.destroyAllWindows()
