# -*- coding: utf-8 -*-
import numpy as np
import cv2
import base64


def img_to_base64(img):
    return base64.b64encode(cv2.imencode('.jpg', img)[1]).decode()


def img_from_base64(img_base64):
    jpg_original = base64.b64decode(img_base64)
    jpg_as_np = np.frombuffer(jpg_original, dtype=np.uint8)
    img = cv2.imdecode(jpg_as_np, flags=1)
    return img


if __name__ == '__main__':
    img = cv2.imread('bug.jpg')

    img_base64 = img_to_base64(img)
    img = img_from_base64(img_base64)

    cv2.imshow('img_decode', img)
    cv2.waitKey()
    cv2.destroyAllWindows()
