# 图像像素颜色

认识颜色空间，OpenCV 常用的颜色空间有 RGB颜色空间、HSV颜色空间、Lab颜色空间。以下选项中<span style="color:red">不正确</span>打印像素(100,100)处颜色空间分量名字的是？

## template

```python
import numpy as np
import cv2 as cv

if __name__ == '__main__':
    img = cv.imread('lena.png', cv.COLOR_BGR2LAB)
    px = img[100, 100]
    print(f'L:{px[0]}, a:{px[0]}, b:{px[0]}')

    img = cv.imread('lena.png', cv.COLOR_BGR2HSV)
    px = img[100, 100]
    print(f'Hue:{px[0]}, Saturation:{px[0]}, Value:{px[0]}')

    img = cv.imread('lena.png', cv.IMREAD_COLOR)
    px = img[100, 100]
    print(f'blue:{px[0]}, green:{px[0]}, red:{px[0]}')
```

## 答案

```python
import numpy as np
import cv2 as cv

if __name__ == '__main__':
    img = cv.imread('lena.png', cv.IMREAD_COLOR)
    px = img[100, 100]
    print(f'red:{px[0]}, green:{px[0]}, blue:{px[0]}')
```

## 选项

### 使用了RGB颜色空间，颜色通道分别是BGR

```python
import numpy as np
import cv2 as cv

if __name__ == '__main__':
    img = cv.imread('lena.png', cv.IMREAD_COLOR)
    px = img[100, 100]
    print(f'blue:{px[0]}, green:{px[0]}, red:{px[0]}')
```

### 使用了HSV颜色空间

```python
import numpy as np
import cv2 as cv

if __name__ == '__main__':
    img = cv.imread('lena.png', cv.COLOR_BGR2HSV)
    px = img[100, 100]
    print(f'Hue:{px[0]}, Saturation:{px[0]}, Value:{px[0]}')
```

### 使用了Lab颜色空间

```python
import numpy as np
import cv2 as cv

if __name__ == '__main__':
    img = cv.imread('lena.png', cv.COLOR_BGR2LAB)
    px = img[100, 100]
    print(f'L:{px[0]}, a:{px[0]}, b:{px[0]}')
```
