import numpy as np
import cv2
import math


def hacker_1(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img.item((i, j, 0)), img.item(
                (i, j, 1)), img.item((i, j, 2))
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img.itemset((i, j, 0), hack_b)
            img.itemset((i, j, 1), hack_g)
            img.itemset((i, j, 2), hack_r)


def hacker_2(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img[i, j]
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img[i, j] = (hack_b, hack_g, hack_r)


def hacker_3(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img.item((i, j))
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img.itemset((i, j), (hack_b, hack_g, hack_r))


def hacker(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img[i, j]
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img[i, j, 0] = hack_b
            img[i, j, 1] = hack_g
            img[i, j, 2] = hack_r


if __name__ == '__main__':
    img_origin = cv2.imread('lena.png', cv2.IMREAD_COLOR)
    img = cv2.imread('lena.png', cv2.IMREAD_COLOR)
    print(img.size)
    print(img.shape)

    hacker(img)

    print('显示图片，请按任意键退出')
    numpy_horizontal_concat = np.concatenate((img_origin, img), axis=1)
    cv2.imshow('Lena图片黑客帝国化', numpy_horizontal_concat)
    cv2.waitKey()
    cv2.destroyAllWindows()
