# 梅西足球的轨迹

使用 OpenCV 可以方便的剪切粘贴图像上的区域。例如下图是梅西在踢足球
![](./ball.jpg)

通过剪切粘贴可以获得足球连续运行的轨迹
![](./ball_continue.jpg)

实现代码如下，需要补全TODO部分：

```python
import cv2
import numpy as np

if __name__ == '__main__':
    img = cv2.imread('ball.jpg', cv2.IMREAD_COLOR)
    start = [493, 594]
    end = [112, 213]
    ball = img[start[0]:start[1], end[0]:end[1]]
    x_step = 101
    y_step = 10
    for i in range(-1, 4):
        # TODO(You): 请在此实现代码

    cv2.imshow("ball_continue", img)
    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

请实现粘贴足球部分的代码。

## template

```python
import cv2
import numpy as np

if __name__ == '__main__':
    img = cv2.imread('ball.jpg', cv2.IMREAD_COLOR)
    start = [493, 594]
    end = [112, 213]
    ball = img[start[0]:start[1], end[0]:end[1]]
    x_step = 101
    y_step = 10
    for i in range(-1, 4):
        x_offset = x_step*i
        y_offset = y_step*i
        img[start[0]-y_offset:start[1]-y_offset,
            end[0]+x_offset:end[1]+x_offset] = ball

    cv2.imshow("ball_continue", img)
    cv2.waitKey(0)
    cv2.destroyAllWindows()

```

## 答案

```python
x_offset = x_step*i
y_offset = y_step*i
img[start[0]-y_offset:start[1]-y_offset, end[0]+x_offset:end[1]+x_offset] = ball
```

## 选项

### A

```python
x_offset = x_step*i
y_offset = y_step*i
img[start[0]+y_offset:start[1]+y_offset, end[0]+x_offset:end[1]+x_offset] = ball
```

### B

```python
x_offset = x_step*i
y_offset = y_step*i
img[start[0]+y_offset:start[1]+y_offset, end[0]-x_offset:end[1]-x_offset] = ball
```

### C

```python
x_offset = x_step*i
y_offset = y_step*i
img[start[0]-y_offset:start[1]-y_offset, end[0]-x_offset:end[1]-x_offset] = ball
```
