# Hello World

以下 `Hello World` 程序中，能够正确执行下述操作的是？
1. 读取目录下`lena`图片
2. 显示`lena`图像窗口
3. 等待用户输入任意按键后关闭窗口

## 答案

```cpp
#include <opencv2/opencv.hpp>
using namespace cv;

int main() {
  Mat img = imread("lena.png");
  imshow("lena", img);
  waitKey(0);
  destroyAllWindows();
  return 0;
}
```

## 选项

### 没有显示图像

```cpp
#include <opencv2/opencv.hpp>
using namespace cv;

int main() {
  Mat img = imread("lena.png");
  waitKey(0);
  destroyAllWindows();
  return 0;
}
```

### imshow参数顺序错误

```cpp
#include <opencv2/opencv.hpp>
using namespace cv;

int main() {
  Mat img = imread("lena.png");
  imshow(img, "lena");
  waitKey(0);
  destroyAllWindows();
  return 0;
}
```

### 忘记销毁窗口

```cpp
#include <opencv2/opencv.hpp>
using namespace cv;

int main() {
  Mat img = imread("lena.png");
  imshow("lena", img);
  waitKey(0);
  return 0;
}
```

### 没有等待用户输入按键

```cpp
#include <opencv2/opencv.hpp>
using namespace cv;

int main() {
  Mat img = imread("lena.png");
  imshow("lena", img);
  destroyAllWindows();
  return 0;
}
```