# 如影随形

通过特征匹配，可以把亭子和水中的倒影做特征匹配

![](./tower_match.jpeg)

框架代码如下：

```python
import cv2
import numpy as np

if __name__ == '__main__':
    img1 = cv2.imread('tower01.jpg', -1)
    img2 = cv2.imread('tower02.jpg', -1)

    # TODO(You):  请在此实现代码
    
    cv2.imwrite('tower_match.jpeg', match_img)
    cv2.waitKey()
    cv2.destroyAllWindows()
```

以下代码实现正确的是？

## 答案

```python
orb = cv2.ORB_create(nfeatures=500)
kp1, des1 = orb.detectAndCompute(img1, None)
kp2, des2 = orb.detectAndCompute(img2, None)

bf = cv2.BFMatcher(cv2.NORM_HAMMING, crossCheck=True)
matches = bf.match(des1, des2)

matches = sorted(matches, key=lambda x: x.distance)
match_img = cv2.drawMatches(img1, kp1, img2, kp2, matches[:50], None)
```

## 选项

### 检测错误

```python
kp1, des1 = cv2.detectAndCompute(img1, None)
kp2, des2 = cv2.detectAndCompute(img2, None)

bf = cv2.BFMatcher(cv2.NORM_HAMMING, crossCheck=True)
matches = bf.match(des1, des2)

matches = sorted(matches, key=lambda x: x.distance)
match_img = cv2.drawMatches(img1, kp1, img2, kp2, matches[:50], None)
```

### 匹配错误

```python
orb = cv2.ORB_create(nfeatures=500)
kp1, des1 = orb.detectAndCompute(img1, None)
kp2, des2 = orb.detectAndCompute(img2, None)

matches = cv2.match(des1, des2)

matches = sorted(matches, key=lambda x: x.distance)
match_img = cv2.drawMatches(img1, kp1, img2, kp2, matches[:50], None)
```

### 排序错误

```python
orb = cv2.ORB_create(nfeatures=500)
kp1, des1 = orb.detectAndCompute(img1, None)
kp2, des2 = orb.detectAndCompute(img2, None)

bf = cv2.BFMatcher(cv2.NORM_HAMMING, crossCheck=True)
matches = bf.match(des1, des2)

matches = sorted(matches, key=lambda x: x.distance)
match_img = bf.drawMatches(img1, kp1, img2, kp2, matches[:50], None)
```
