# 浑水摸鱼

通过调整图像的直方图调整图像的整体细节，下图左图是浑水鱼，右边清澈鱼。

![](./fish_enhance.jpeg)

框架代码如下：

```python
import numpy as np
import cv2

if __name__ == '__main__':
    fish = cv2.imread('fish.jpeg', -1)

    # TODO(You): 请正确实现浑水摸鱼代码

    images = np.concatenate((fish, fish_enhance), axis=1)
    cv2.imwrite('fish_enhance.jpeg', images)
    cv2.imshow('fish_enhance', images)
    cv2.waitKey()
    cv2.destroyAllWindows()
```

直方图均衡化只能对灰度图使用。下面的实现正确的是？

## 答案

```python
b, g, r = cv2.split(fish)
bx, gx, rx = cv2.equalizeHist(b), cv2.equalizeHist(g), cv2.equalizeHist(r)
fish_enhance = cv2.merge((bx, gx, rx))
```

## 选项

### 没有分离灰度图

```python
fish_enhance = cv2.equalizeHist(fish)
```

### 参数不对

```python
b, g, r = cv2.split(fish)
bx, gx, rx = cv2.equalizeHist(b), cv2.equalizeHist(g), cv2.equalizeHist(r)
fish_enhance = cv2.merge(bx, gx, rx)
```

### 参数错误

```python
b, g, r = fish.split()
bx, gx, rx = cv2.equalizeHist(b), cv2.equalizeHist(g), cv2.equalizeHist(r)
fish_enhance = cv2.merge((bx, gx, rx))
```
