# 小鸊鷉橡皮擦(II)

OpenCV 里先膨胀再腐蚀操作叫做“闭运算”。小鸊鷉(pi ti)的名片被小朋友画了几笔，尝试通过先膨胀再腐蚀修复，完成任务

![](./img_closed.jpeg)

框架代码如下：

```python
import numpy as np
import cv2

def close_op(img):
    # TODO(You): 请在此实现代码

if __name__ == '__main__':
    img_origin = cv2.imread('bird.png', cv2.COLOR_BGR2LAB)

    img_opened = open_op(img_origin)

    img_all = np.concatenate((img_origin, img_opened), axis=1)
    cv2.imwrite('img_opened.jpeg', img_all)
    cv2.imshow('img: origin, erosion and dilation', img_all)

    cv2.waitKey(0)
    cv2.destroyAllWindows()

```

下面对开运算函数`def close_op(img):`实现正确的是？

## 答案

```python
def close_op(img):
    kernel = np.ones((3, 3), np.uint8)
    img1 = cv2.dilate(img, kernel, iterations=1)
    img2 = cv2.erode(img1, kernel, iterations=1)
    return img2
```

## 选项

### 都是对原图操作

```python
def close_op(img):
    kernel = np.ones((3, 3), np.uint8)
    img1 = cv2.dilate(img, kernel, iterations=1)
    img2 = cv2.erode(img, kernel, iterations=1)
    return img2
```

### 顺序不对

```python
def close_op(img):
    kernel = np.ones((3, 3), np.uint8)
    img1 = cv2.erode(img, kernel, iterations=1)
    img2 = cv2.dilate(img1, kernel, iterations=1)
    return img2
```

### 返回错误

```python
def close_op(img):
    kernel = np.ones((3, 3), np.uint8)
    img1 = cv2.dilate(img, kernel, iterations=1)
    img2 = cv2.erode(img1, kernel, iterations=1)
    return img1
```
