# Hello World

![](./lena.png)

以下 `Hello World` 程序中，能够正确执行下述操作的是？

1. 读取目录下`lena`图片
2. 显示`lena`图像窗口
3. 等待用户输入任意按键后关闭窗口
4. 销毁所有窗口

## 答案

```python
import cv2

if __name__ == '__main__':
    img = cv2.imread("lena.png")
    cv2.imshow("lena", img)
    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

## 选项

### 没有显示图像

```python
import cv2

if __name__ == '__main__':
    img = cv2.imread("lena.png")
    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

### imshow参数顺序错误

```python
import cv2

if __name__ == '__main__':
    img = cv2.imread("lena.png")
    cv2.imshow(img, "lena")
    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

### 忘记销毁窗口

```python
import cv2

if __name__ == '__main__':
    img = cv2.imread("lena.png")
    cv2.imshow("lena", img)
    cv2.waitKey(0)
```

### 没有等待用户输入按键

```python
import cv2

if __name__ == '__main__':
    img = cv2.imread("lena.png")
    cv2.imshow("lena", img)
    cv2.destroyAllWindows()
```
