import numpy as np
import cv2

if __name__ == '__main__':
    cap = cv2.VideoCapture('ant.mp4')

    # ShiTomasi 角点检测参数
    feature_params = dict(
        maxCorners=100,
        qualityLevel=0.5,
        minDistance=30,
        blockSize=10
    )

    # Lucas Kanada 光流检测参数
    lk_params = dict(
        winSize=(15, 15),
        maxLevel=2,
        criteria=(cv2.TERM_CRITERIA_EPS | cv2.TERM_CRITERIA_COUNT, 10, 0.03)
    )

    # 获取第一帧并发现角点
    ret, last_current_frame = cap.read()
    last_gray = cv2.cvtColor(last_current_frame, cv2.COLOR_BGR2GRAY)

    p0 = cv2.goodFeaturesToTrack(last_gray, mask=None, **feature_params)
    mask = np.zeros_like(last_current_frame)

    color = np.random.randint(0, 255, (100, 3))
    while (1):
        ret, current_frame = cap.read()

        if not ret:
            break

        current_gray = cv2.cvtColor(current_frame, cv2.COLOR_BGR2GRAY)

        p1, st, err = cv2.calcOpticalFlowPyrLK(
            last_gray, current_gray, p0, None, **lk_params)

        good_new = p1[st == 1]
        good_old = p0[st == 1]

        for i, (new, old) in enumerate(zip(good_new, good_old)):
            a, b = new.ravel()
            c, d = old.ravel()
            a, b = int(a), int(b)
            c, d = int(c), int(d)
            mask = cv2.line(mask, (a, b), (c, d), color[i].tolist(), 2)
            current_frame = cv2.circle(
                current_frame, (a, b), 5, color[i].tolist(), -1)

        current_img = cv2.add(current_frame, mask)
        cv2.imshow('current_img', current_img)

        k = cv2.waitKey(30) & 0xff
        if k == 27:
            break

        last_gray = current_gray.copy()
        p0 = good_new.reshape(-1, 1, 2)

    cv2.destroyAllWindows()
    cap.release()
