import cv2
import numpy as np


def close_op(img):
    kernel = np.ones((5, 5), np.uint8)
    img1 = cv2.dilate(img, kernel, iterations=1)
    img2 = cv2.erode(img, kernel, iterations=1)
    return img2


def filter_green(img):
    hsv = cv2.cvtColor(img, cv2.COLOR_BGR2HSV)
    lower_green = np.array([50, 100, 50])
    upper_green = np.array([70, 255, 255])
    lower_red = np.array([0, 20, 100])
    upper_red = np.array([10, 255, 255])

    mask = cv2.inRange(hsv, lower_red, upper_red)
    res = cv2.bitwise_and(img, img, mask=mask)
    return close_op(res)


if __name__ == '__main__':
    imput_img = 'tower.jpeg'

    ori = cv2.imread(imput_img)
    image = cv2.imread(imput_img)

    no_green = filter_green(image)
    gray = cv2.cvtColor(no_green, cv2.COLOR_BGR2GRAY)
    gray = np.float32(gray)

    dst = cv2.cornerHarris(gray, 2, 3, 0.04)
    dst = cv2.dilate(dst, None)

    image[dst > 0.01*dst.max()] = [0, 0, 255]

    images = np.concatenate((ori, no_green, image), axis=1)
    # cv2.imwrite('tower_harris.jpeg', images)
    cv2.imshow('tower_harris', images)
    cv2.waitKey()
    cv2.destroyAllWindows()
