# 提取亭子瓦片特征

下图是一个湖边的亭子，通过 OpenCV 的 Harris 特征提取可以提取到亭子的瓦片特征

![](./tower.jpeg)

上图背景图里的植被的角点也会被 Harris 特征提取到，因此我们先用之前学习过的知识过滤出前景图后再做 Harris 特征提取，过程图片如下：

![](./tower_harris.jpeg)

框架代码如下

```python
import cv2
import numpy as np


def close_op(img):
    kernel = np.ones((5, 5), np.uint8)
    img1 = cv2.dilate(img, kernel, iterations=1)
    img2 = cv2.erode(img, kernel, iterations=1)
    return img2


def filter_green(img):
    hsv = cv2.cvtColor(img, cv2.COLOR_BGR2HSV)
    lower_green = np.array([50, 100, 50])
    upper_green = np.array([70, 255, 255])
    lower_red = np.array([0, 20, 100])
    upper_red = np.array([10, 255, 255])

    mask = cv2.inRange(hsv, lower_red, upper_red)
    res = cv2.bitwise_and(img, img, mask=mask)
    return close_op(res)


if __name__ == '__main__':
    imput_img = 'tower.jpeg'

    ori = cv2.imread(imput_img)
    image = cv2.imread(imput_img)

    no_green = filter_green(image)

    # TODO(You): 请在此实现 Harris 特征提取

    images = np.concatenate((ori, no_green, image), axis=1)
    cv2.imwrite('tower_harris.jpeg', images)
    cv2.imshow('tower_harris', images)
    cv2.waitKey()
    cv2.destroyAllWindows()
```

以下正确实现通过 Harris 特征提取亭子瓦片角点的是？

## 答案

```python
gray = cv2.cvtColor(no_green, cv2.COLOR_BGR2GRAY)
gray = np.float32(gray)
dst = cv2.cornerHarris(gray, 2, 3, 0.04)
dst = cv2.dilate(dst, None)
image[dst > 0.01*dst.max()] = [0, 0, 255]
```

## 选项

### 没有取灰度图

```python
dst = cv2.cornerHarris(no_green, 2, 3, 0.04)
dst = cv2.dilate(dst, None)
image[dst > 0.01*dst.max()] = [0, 0, 255]
```

### 没有做膨胀处理

```python
gray = cv2.cvtColor(no_green, cv2.COLOR_BGR2GRAY)
gray = np.float32(gray)
dst = cv2.cornerHarris(gray, 2, 3, 0.04)
image[dst > 0.01*dst.max()] = [0, 0, 255]
```

### 过滤掉代码不对

```python
gray = cv2.cvtColor(no_green, cv2.COLOR_BGR2GRAY)
gray = np.float32(gray)
dst = cv2.cornerHarris(gray, 2, 3, 0.04)
dst = cv2.dilate(dst, None)
image[lambda dst: dst > 0.01*dst.max()] = [0, 0, 255]
```
