import numpy as np
import cv2

if __name__ == '__main__':
    fish = cv2.imread('fish.jpeg', -1)

    b, g, r = cv2.split(fish)
    bx, gx, rx = cv2.equalizeHist(b), cv2.equalizeHist(g), cv2.equalizeHist(r)
    fish_enhance = cv2.merge((bx, gx, rx))

    images = np.concatenate((fish, fish_enhance), axis=1)
    cv2.imwrite('fish_enhance.jpeg', images)
    cv2.imshow('fish_enhance', images)
    cv2.waitKey()
    cv2.destroyAllWindows()
