# 甲壳虫乐队

一只甲壳虫想组个乐队，但是临时找不到队友。请使用 OpenCV 读取下面的彩色甲壳虫图片 `'bug.jpg'`，帮助他变身灰色甲壳虫，然后完成组队。
![](./bug.jpg)

**显示甲壳虫乐队并写入到 `'bug_band.jpg'`**：
![](./bug_band.jpg)

以下实现正确的是？

## 答案

```python
import numpy as np
import cv2

if __name__ == '__main__':
    bug_img = cv2.imread("bug.jpg")
    bug_img_gray = cv2.cvtColor(bug_img, cv2.COLOR_BGR2GRAY)

    bug_img_gray_by_BGR_space = cv2.cvtColor(bug_img_gray, cv2.COLOR_GRAY2BGR)
    bug_img_concat = np.concatenate(
        (bug_img, bug_img_gray_by_BGR_space),
        axis=1
    )
    cv2.imwrite("bug_band.jpg", bug_img_concat)

    cv2.imshow('甲壳虫乐队', bug_img_concat)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

## 选项

### 读写api名字错误

```python
import numpy as np
import cv2

if __name__ == '__main__':
    bug_img = cv2.read("bug.jpg")
    bug_img_gray = cv2.cvtColor(bug_img, cv2.COLOR_BGR2GRAY)

    bug_img_gray_by_BGR_space = cv2.cvtColor(bug_img_gray, cv2.COLOR_GRAY2BGR)
    bug_img_concat = np.concatenate(
        (bug_img, bug_img_gray_by_BGR_space),
        axis=1
    )
    cv2.write("bug_band.jpg", bug_img_concat)

    cv2.imshow('甲壳虫乐队', bug_img_concat)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

### 写入参数顺序错误

```python
import numpy as np
import cv2

if __name__ == '__main__':
    bug_img = cv2.imread("bug.jpg")
    bug_img_gray = cv2.cvtColor(bug_img, cv2.COLOR_BGR2GRAY)

    bug_img_gray_by_BGR_space = cv2.cvtColor(bug_img_gray, cv2.COLOR_GRAY2BGR)
    bug_img_concat = np.concatenate(
        (bug_img, bug_img_gray_by_BGR_space),
        axis=1
    )
    cv2.imwrite(bug_img_concat, "bug_band.jpg")

    cv2.imshow('甲壳虫乐队', bug_img_concat)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

### 不能合并彩色和灰色，尺寸不同

```python
import numpy as np
import cv2

if __name__ == '__main__':
    bug_img = cv2.imread("bug.jpg")
    bug_img_gray = cv2.cvtColor(bug_img, cv2.COLOR_BGR2GRAY)

    bug_img_concat = np.concatenate(
        (bug_img, bug_img_gray),
        axis=1
    )
    cv2.imwrite("bug_img_concat.jpg", bug_img_concat)

    cv2.imshow('甲壳虫乐队', bug_img_gray)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
```
