import numpy as np
import cv2


def open_op(img):
    kernel = np.ones((3, 3), np.uint8)
    img1 = cv2.erode(img, kernel, iterations=1)
    img2 = cv2.dilate(img1, kernel, iterations=1)
    return img2


if __name__ == '__main__':
    img_origin = cv2.imread('bird.png', cv2.COLOR_BGR2LAB)

    img_opened = open_op(img_origin)

    img_all = np.concatenate((img_origin, img_opened), axis=1)
    cv2.imwrite('img_opened.jpeg', img_all)
    cv2.imshow('img: origin, erosion and dilation', img_all)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
