# 早起的鸟儿有虫吃

早起的鸟儿不但有虫吃，还可以照镜子。请你帮助鸟儿们跟镜像合影。

这是鸟儿的视频：
<object width="500" height="300" data="./birds.mp4"></object>

这是合影的效果：
<object width="500" height="300" data="./birds_concat.mp4"></object>

基本的实现代码如下，合影每10帧采样一次：

```python
import numpy as np
import cv2

if __name__ == '__main__':
    cap = cv2.VideoCapture('birds.mp4')

    out = ...
    # TODO(You): 请在此正确创建待保存的目标mp4文件`out`

    i = 0
    while(cap.isOpened()):

        ret, bird_frame = cap.read()
        if bird_frame is None:
            break

        bird_flip_frame = cv2.flip(bird_frame, 0)
        bird_concat_frame = np.concatenate(
            (bird_frame, bird_flip_frame),
            axis=1
        )

        cv2.imshow('bird_concat_frame', bird_concat_frame)
        if i % 10 == 0:
            out.write(bird_concat_frame)
        i += 1
        if cv2.waitKey(1) & 0xFF == ord('q'):
            break

    out.release()
    cap.release()

    cv2.destroyAllWindows()
```

以下正确创建了输出mp4文件`out`变量的是？

## 答案

```python
width = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
height = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))
fps = cap.get(cv2.CAP_PROP_FPS)
out = cv2.VideoWriter(
    'birds_concat.mp4',
    cv2.VideoWriter_fourcc(*'mp4v'),
    fps,
    (width*2, height)
)
```

## 选项

### 宽度不对

```python
width = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
height = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))
fps = cap.get(cv2.CAP_PROP_FPS)
out = cv2.VideoWriter(
    'birds_concat.mp4',
    cv2.VideoWriter_fourcc(*'mp4v'),
    fps,
    (width, height)
)
```

### 格式不对

```python
width = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
height = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))
fps = cap.get(cv2.CAP_PROP_FPS)
out = cv2.VideoWriter(
    'birds_concat.mp4',
    cv2.VideoWriter_fourcc(*'MP4V'),
    fps,
    (width, height)
)
```

### 宽度和长度类型不对

```python
width = cap.get(cv2.CAP_PROP_FRAME_WIDTH)
height = cap.get(cv2.CAP_PROP_FRAME_HEIGHT)
fps = cap.get(cv2.CAP_PROP_FPS)
out = cv2.VideoWriter(
    'birds_concat.mp4',
    cv2.VideoWriter_fourcc(*'MP4V'),
    fps,
    (width, height)
)
```
