import numpy as np
import cv2

if __name__ == '__main__':
    bug_img = cv2.imread("bug.jpg")
    bug_img_gray = cv2.cvtColor(bug_img, cv2.COLOR_BGR2GRAY)

    bug_img_gray_by_BGR_space = cv2.cvtColor(bug_img_gray, cv2.COLOR_GRAY2BGR)
    bug_img_concat = np.concatenate(
        (bug_img, bug_img_gray_by_BGR_space),
        axis=1
    )
    cv2.imwrite("bug_band.jpg", bug_img_concat)

    cv2.imshow('甲壳虫乐队', bug_img_concat)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
