# 普通鸬鹚不普通

OpenCV的膨胀与腐蚀，让“普通鸬鹚”不普通，下图从左到右分别是：

* 原图
* 原图经过膨胀得到的图
* 原图经过腐蚀得到的图

![](./bird_erosion_dilation.jpeg)

下面对腐蚀和膨胀实现代码正确的是？


## 答案

```python
import numpy as np
import cv2

if __name__ == '__main__':
    img_origin = cv2.imread('bird.jpeg', cv2.COLOR_BGR2LAB)

    kernel = np.ones((3, 3), np.uint8)
    img_erosion = cv2.erode(img_origin, kernel, iterations=1)
    img_dilation = cv2.dilate(img_origin, kernel, iterations=1)

    img_all = np.concatenate((img_origin, img_erosion, img_dilation), axis=1)
    cv2.imshow('img: origin, erosion and dilation', img_all)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

## 选项

### 没有使用核函数

```python
import numpy as np
import cv2

if __name__ == '__main__':
    img_origin = cv2.imread('bird.jpeg', cv2.COLOR_BGR2LAB)

    img_erosion = cv2.erode(img_origin, iterations=1)
    img_dilation = cv2.dilate(img_origin, iterations=1)

    img_all = np.concatenate((img_origin, img_erosion, img_dilation), axis=1)
    cv2.imshow('img: origin, erosion and dilation', img_all)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

### 参数顺序不对

```python
import numpy as np
import cv2

if __name__ == '__main__':
    img_origin = cv2.imread('bird.jpeg', cv2.COLOR_BGR2LAB)

    kernel = np.ones((3, 3), np.uint8)
    img_erosion = cv2.erode(kernel, img_origin, iterations=1)
    img_dilation = cv2.dilate(kernel, img_origin, iterations=1)

    img_all = np.concatenate((img_origin, img_erosion, img_dilation), axis=1)
    cv2.imshow('img: origin, erosion and dilation', img_all)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

### 顺序反了

```python
import numpy as np
import cv2

if __name__ == '__main__':
    img_origin = cv2.imread('bird.jpeg', cv2.COLOR_BGR2LAB)

    kernel = np.ones((3, 3), np.uint8)
    img_erosion = cv2.dilate(img_origin, kernel, iterations=1)
    img_dilation = cv2.erode(img_origin, kernel, iterations=1)

    img_all = np.concatenate((img_origin, img_erosion, img_dilation), axis=1)
    cv2.imshow('img: origin, erosion and dilation', img_all)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
```
