import numpy as np
import cv2


def close_op(img):
    kernel = np.ones((3, 3), np.uint8)
    img1 = cv2.dilate(img, kernel, iterations=1)
    img2 = cv2.erode(img1, kernel, iterations=1)
    return img2


if __name__ == '__main__':
    img_origin = cv2.imread('bird.png', cv2.COLOR_BGR2LAB)

    img_closed = close_op(img_origin)

    img_all = np.concatenate((img_origin, img_closed), axis=1)
    cv2.imwrite('img_closed.jpeg', img_all)
    cv2.imshow('img: origin, erosion and dilation', img_all)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
