# 仿射变换

几何变换是指对对图像的位置、大小、形状、投影进行变换，是将图像从原始平面投影到新的视平面。仿射变换（Affine）的特点是原始图像中的平行关系和线段长度比例关系保持不变。

仿射变换矩阵中有 6 个未知参数，cv2.getAffineTransform() 根据图像中不共线的 3 个点在变换前后的对应位置坐标，求出仿射变换矩阵。cv2.warpAffine() 通过变换矩阵计算得到变换后的图像。

**函数说明：**

```
cv2.warpAffine(src, M, dsize[, dst[, flags[, borderMode[, borderValue]]]]) → dst
```

旋转也是一种简单仿射变换，我们用变换矩阵将下面的色块图旋转一下，看看会产生什么样的效果吧。

![](./affine2.png)

下面对仿射变换实现代码正确的是？

##  答案

```
import cv2 as cv
import numpy as np

if __name__ == '__main__':
    img = cv.imread("affine1.jpg")

    pts1 = np.float32([[50, 50], [200, 50], [50, 200]])
    pts2 = np.float32([[50, 100], [200, 50], [100, 250]])
    MA = cv.getAffineTransform(pts1, pts2)
    dst = cv.warpAffine(img, MA, img.shape[:2])

    cv.imshow("Origin image", img)
    cv.imshow("Affine transform", dst)
    cv.waitKey(0)
```

##  选项

###  需要 3个给定点变换前后的位置才能计算变换矩阵

```
import cv2 as cv
import numpy as np

if __name__ == '__main__':
    img = cv.imread("affine1.jpg")

    pts1 = np.float32([[50, 50], [200, 50]])
    pts2 = np.float32([[50, 100], [200, 50]])
    MA = cv.getAffineTransform(pts1, pts2)
    dst = cv.warpAffine(img, MA, img.shape[:2])

    cv.imshow("Origin image", img)
    cv.imshow("Affine transform", dst)
    cv.waitKey(0)
```

###  函数 cv.getAffineTransform() 缺少给定点变换后的位置

```
import cv2 as cv
import numpy as np

if __name__ == '__main__':
    img = cv.imread("affine1.jpg")  # 读取彩色图像(BGR)

    pts1 = np.float32([[50, 50], [200, 50], [50, 200]])
    MA = cv.getAffineTransform(pts1)
    dst = cv.warpAffine(img, MA, img.shape[:2])

    cv.imshow("Origin image", img)
    cv.imshow("Affine transform", dst)
    cv.waitKey(0)

```

###  函数 cv.warpAffine() 缺少参数：图像大小 dsize

```
import cv2 as cv
import numpy as np

if __name__ == '__main__':
    img = cv.imread("affine1.jpg")  # 读取彩色图像(BGR)

    pts1 = np.float32([[50, 50], [200, 50], [50, 200]])
    pts2 = np.float32([[50, 100], [200, 50], [100, 250]])
    MA = cv.getAffineTransform(pts1, pts2)
    dst = cv.warpAffine(img, MA)

    cv.imshow("Origin image", img)
    cv.imshow("Affine transform", dst)
    cv.waitKey(0)
```
