import cv2 as cv

if __name__ == '__main__':
    img = cv.imread("Contours.jpg", flags=1)
    imgGray = cv.cvtColor(img, cv.COLOR_BGR2GRAY)

    ret, thresh = cv.threshold(imgGray, 127, 255, cv.THRESH_BINARY_INV)
    image, contours, hierarchy = cv.findContours(thresh, cv.RETR_TREE, cv.CHAIN_APPROX_SIMPLE)
    contourPic = cv.drawContours(img, contours, -1, (0, 0, 255), 2)

    cv.imshow("ContourPicture", contourPic)
    cv.waitKey(0)