# 使用Python+OpenCV实现姿态估计



姿态估计使用Opencv+Mediapipe来时实现

**什么是Mediapipe？**

Mediapipe是主要用于构建多模式音频，视频或任何时间序列数据的框架。借助MediaPipe框架，可以构建令人印象深刻的ML管道，例如TensorFlow，TFLite等推理模型以及媒体处理功能。

安装命令：

```
pip install mediapipe
```

如果没有安装需要安装，请执行这个命令。

通过视频或实时馈送进行人体姿态估计在诸如全身手势控制，量化体育锻炼和手语识别等各个领域中发挥着至关重要的作用。

例如，它可用作健身，瑜伽和舞蹈应用程序的基本模型。它在增强现实中找到了自己的主要作用。

Media Pipe Pose是用于高保真人体姿势跟踪的框架，该框架从RGB视频帧获取输入并推断出整个人类的33个3D界标。当前最先进的方法主要依靠强大的桌面环境进行推理，而此方法优于其他方法，并且可以实时获得很好的结果。

模型可以预测33个关键点，如下图：

![img](https://gitee.com/wanghao1090220084/cloud-image/raw/master/pose_tracking_full_body_landmarks.png)

我们使用OpenCV+mediapipe实现姿态估计，我已经实现了代码，请大家找出能够正确执行的代码！

# 框架代码

```
import cv2
import mediapipe as mp
import time

mpPose = mp.solutions.pose
pose = mpPose.Pose()
mpDraw = mp.solutions.drawing_utils
cap = cv2.VideoCapture('1.mp4')
pTime = 0
#输出检测结果

# do a bit of cleanup
cv2.destroyAllWindows()
cap.release()


```

# 答案：

```
while True:
    success, img = cap.read()
    if success is False:
        break
    imgRGB = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)
    results = pose.process(imgRGB)
    if results is None:
        continue
    print(results.pose_landmarks)
    if results.pose_landmarks:
        mpDraw.draw_landmarks(img, results.pose_landmarks, mpPose.POSE_CONNECTIONS)
    for id, lm in enumerate(results.pose_landmarks.landmark):
        h, w, c = img.shape
    print(id, lm)
    cx, cy = int(lm.x * w), int(lm.y * h)
    cv2.circle(img, (cx, cy), 5, (255, 0, 0), cv2.FILLED)
    cTime = time.time()
    fps = 1 / (cTime - pTime)
    pTime = cTime
    cv2.putText(img, str(int(fps)), (50, 50), cv2.FONT_HERSHEY_SIMPLEX, 1, (255, 0, 0), 3)
    cv2.imshow("Image", img)
    key = cv2.waitKey(1) & 0xFF
```

# 选项

## 读取帧失败后没有终止逻辑

```
while True:
    success, img = cap.read()
    imgRGB = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)
    results = pose.process(imgRGB)
    if results is None:
        continue
    print(results.pose_landmarks)
    if results.pose_landmarks:
        mpDraw.draw_landmarks(img, results.pose_landmarks, mpPose.POSE_CONNECTIONS)
    for id, lm in enumerate(results.pose_landmarks.landmark):
        h, w, c = img.shape
    print(id, lm)
    cx, cy = int(lm.x * w), int(lm.y * h)
    cv2.circle(img, (cx, cy), 5, (255, 0, 0), cv2.FILLED)
    cTime = time.time()
    fps = 1 / (cTime - pTime)
    pTime = cTime
    cv2.putText(img, str(int(fps)), (50, 50), cv2.FONT_HERSHEY_SIMPLEX, 1, (255, 0, 0), 3)
    cv2.imshow("Image", img)
    key = cv2.waitKey(1) & 0xFF
```

## results为None时没有判断

```
while True:
    success, img = cap.read()
    if success is False:
        break
    imgRGB = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)
    results = pose.process(imgRGB)
    print(results.pose_landmarks)
    if results.pose_landmarks:
        mpDraw.draw_landmarks(img, results.pose_landmarks, mpPose.POSE_CONNECTIONS)
    for id, lm in enumerate(results.pose_landmarks.landmark):
        h, w, c = img.shape
    print(id, lm)
    cx, cy = int(lm.x * w), int(lm.y * h)
    cv2.circle(img, (cx, cy), 5, (255, 0, 0), cv2.FILLED)
    cTime = time.time()
    fps = 1 / (cTime - pTime)
    pTime = cTime
    cv2.putText(img, str(int(fps)), (50, 50), cv2.FONT_HERSHEY_SIMPLEX, 1, (255, 0, 0), 3)
    cv2.imshow("Image", img)
    key = cv2.waitKey(1) & 0xFF
```

img的shape顺序不对

```
while True:
    success, img = cap.read()
    if success is False:
        break
    imgRGB = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)
    results = pose.process(imgRGB)
    if results is None:
        continue
    print(results.pose_landmarks)
    if results.pose_landmarks:
        mpDraw.draw_landmarks(img, results.pose_landmarks, mpPose.POSE_CONNECTIONS)
    for id, lm in enumerate(results.pose_landmarks.landmark):
        c,h, w = img.shape
    print(id, lm)
    cx, cy = int(lm.x * w), int(lm.y * h)
    cv2.circle(img, (cx, cy), 5, (255, 0, 0), cv2.FILLED)
    cTime = time.time()
    fps = 1 / (cTime - pTime)
    pTime = cTime
    cv2.putText(img, str(int(fps)), (50, 50), cv2.FONT_HERSHEY_SIMPLEX, 1, (255, 0, 0), 3)
    cv2.imshow("Image", img)
    key = cv2.waitKey(1) & 0xFF
```

