# 识别野外拍摄的鸟

使用基本的OpenCV轮廓检测识别出野外拍摄照片里的鸟

![](./birds_detect.jpeg)

基本框架如下：

```python
import cv2

if __name__ == '__main__':
    img = cv2.imread('bird.jpeg', -1)
    img_gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)

    ret, img_binary = cv2.threshold(
        img_gray, 127, 255, cv2.THRESH_BINARY)
    ret, bin_img = cv2.threshold(
        img_binary, 0, 255, cv2.THRESH_BINARY+cv2.THRESH_OTSU)

    # findCountours 函数在版本4之后返回参数只有2个
    if (int(cv2.__version__[0]) > 3):
        contours, hierarchy = cv2.findContours(
            bin_img, cv2.RETR_TREE, cv2.CHAIN_APPROX_SIMPLE)
    else:
        img2, contours, hierarchy = cv2.findContours(
            bin_img, cv2.RETR_TREE, cv2.CHAIN_APPROX_SIMPLE)

    # TODO(You): 请在此实现代码

    cv2.imwrite('birds_detect.jpeg', img)
    cv2.imshow("birds", img)
    cv2.waitKey(0)
    cv2.destroyAllWindows()
```

以下实现正确的代码是？

## 答案

```python
sorted_contours = sorted(contours, key=cv2.contourArea, reverse=False)
max_contour = sorted_contours[-2]
max_contour_area = cv2.contourArea(max_contour)

bird_contours = filter(lambda c: abs(
    cv2.contourArea(c)-max_contour_area) < 1000, sorted_contours)

for c in bird_contours:
    x, y, w, h = cv2.boundingRect(c)
    cv2.rectangle(img, (x-10, y-100),
                    (x+w+10, y+h+10), (0, 255, 0), 2)
    cv2.drawContours(img, c, -1, (0, 0, 255), 3)
```

## 选项

### 没有根据面积排序

```python
sorted_contours = sorted(contours, reverse=False)
max_contour = sorted_contours[-2]
max_contour_area = cv2.contourArea(max_contour)

bird_contours = filter(lambda c: abs(
    cv2.contourArea(c)-max_contour_area) < 1000, sorted_contours)

for c in bird_contours:
    x, y, w, h = cv2.boundingRect(c)
    cv2.rectangle(img, (x-10, y-100),
                    (x+w+10, y+h+10), (0, 255, 0), 2)
    cv2.drawContours(img, c, -1, (0, 0, 255), 3)
```

### 没有过滤出面积与最大鸟差不多的矩形

```python
sorted_contours = sorted(contours, key=cv2.contourArea, reverse=False)
max_contour = sorted_contours[-2]
max_contour_area = cv2.contourArea(max_contour)

for c in sorted_contours:
    x, y, w, h = cv2.boundingRect(c)
    cv2.rectangle(img, (x-10, y-100),
                    (x+w+10, y+h+10), (0, 255, 0), 2)
    cv2.drawContours(img, c, -1, (0, 0, 255), 3)
```

### 过滤不对

```python
sorted_contours = sorted(contours, key=cv2.contourArea, reverse=False)
max_contour = sorted_contours[-2]

max_contour_area = cv2.contourArea(max_contour)
bird_contours = filter(lambda c: cv2.contourArea(c)>max_contour_area, sorted_contours)

for c in bird_contours:
    x, y, w, h = cv2.boundingRect(c)
    cv2.rectangle(img, (x-10, y-100),
                    (x+w+10, y+h+10), (0, 255, 0), 2)
    cv2.drawContours(img, c, -1, (0, 0, 255), 3)
```
