import cv2
import numpy as np
import matplotlib.pyplot as plt

if __name__ == '__main__':
    # img_src = cv2.imread('rust_face_src.jpeg')
    # pts_src = np.array([[0, 0], [570, 0], [570, 1078], [0, 1078]])

    # img_dst = cv2.imread('rust_face_dest.jpeg')
    # pts_dst = np.array([[63, 285], [378, 224], [427, 689], [84, 820]])

    img_src = cv2.imread('rust_face_src.jpeg')
    pts_src = np.array([[0, 0], [0, 1078], [570, 0], [570, 1078]])

    img_dst = cv2.imread('rust_face_dest.jpeg')
    pts_dst = np.array([[63, 285], [84, 820], [378, 224], [427, 689]])

    dw, dh = img_dst.shape[1], img_dst.shape[0]

    h, status = cv2.findHomography(pts_src, pts_dst)
    img_out = cv2.warpPerspective(img_src, h, (dw, dh))

    images = np.concatenate(
        (img_src[0: dh, 0:dw, 0:3], img_dst, img_out), axis=1)
    cv2.imshow('homography', images)

    cv2.waitKey(0)
    cv2.destroyAllWindows()
