# 图像的灰度化处理

按照颜色对图像进行分类，可以分为彩色图像、灰度图像和二值图像。

灰度图像是只含亮度信息，不含色彩信息的图像。

灰度化处理是把彩色图像转换为灰度图像的过程，是图像处理中的基本操作。 

OpenCV 中彩色图像使用 BGR 格式。灰度图像中用 8bit 数字 0～255 表示灰度，如：0 表示纯黑，255 表示纯白。

彩色图像进行灰度化处理，可以在读取图像文件时直接读取为灰度图像，也可以通过函数  `cv.cvtColor()` 将彩色图像转换为灰度图像。

以下图像灰度化程序中，能够正确执行图像灰度化操作的是？


##  答案

```
import cv2 as cv
if __name__ == '__main__':
    img = cv.imread("GrayscaleLena.tif")
    imgGray = cv.cvtColor(img, cv.COLOR_BGR2GRAY)
    cv.imshow("ImgGray", imgGray)
    key = cv.waitKey(0)
```

##  选项

###  遗漏了颜色转换代码

```
import cv2 as cv
if __name__ == '__main__':
    img = cv.imread("GrayscaleLena.tif")
    imgGray = cv.cvtColor(img)
    cv.imshow("ImgGray", imgGray)
    key = cv.waitKey(0)
```

###  颜色转换代码错误 

```
import cv2 as cv
if __name__ == '__main__':
    img = cv.imread("GrayscaleLena.tif")
    imgGray = cv.cvtColor(img, cv.COLOR_GRAY2BGR)
    cv.imshow("ImgGray", imgGray)
    key = cv.waitKey(0)
```

###  图片已经读取为灰度图

```
import cv2 as cv
if __name__ == '__main__':
    img = cv.imread("GrayscaleLena.tif", cv.IMREAD_GRAYSCALE)
    imgGray = cv.cvtColor(img, cv.COLOR_BGR2GRAY)
    cv.imshow("ImgGray", imgGray)
    key = cv.waitKey(0)
```
