# 图片黑客帝国化

黑客帝国的图片风格偏绿色，任意图片的每个像素(r,g,b)经过公式转换后即可获得一张“黑客帝国风格图片”：

* r = r<sup>3/2</sup>
* g = r<sup>4/5</sup>
* b = r<sup>3/2</sup>

我们对`lena`图片也做黑客帝国风格化处理：

```python
import numpy as np
import cv2
import math

def hacker(img):
    # TODO(You): 请在此添加代码

if __name__ == '__main__':
    img_origin = cv2.imread('lena.png', cv2.IMREAD_COLOR)
    img = cv2.imread('lena.png', cv2.IMREAD_COLOR)
    print(img.size)
    print(img.shape)

    hacker(img)

    print('显示图片，请按任意键退出')
    numpy_horizontal_concat = np.concatenate((img_origin, img), axis=1)
    cv2.imshow('Lena图片黑客帝国化', numpy_horizontal_concat)
    cv2.waitKey()
    cv2.destroyAllWindows()
```

以下选项是对函数 `def hacker(img)` 的实现，请选出<span style="color:red">实现有错</span>的选项。

## template

```python
import numpy as np
import cv2
import math


def hacker_1(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img.item((i, j, 0)), img.item(
                (i, j, 1)), img.item((i, j, 2))
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img.itemset((i, j, 0), hack_b)
            img.itemset((i, j, 1), hack_g)
            img.itemset((i, j, 2), hack_r)


def hacker_2(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img[i, j]
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img[i, j] = (hack_b, hack_g, hack_r)


def hacker_3(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img.item((i, j))
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img.itemset((i, j), (hack_b, hack_g, hack_r))


def hacker(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img[i, j]
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img[i, j, 0] = hack_b
            img[i, j, 1] = hack_g
            img[i, j, 2] = hack_r


if __name__ == '__main__':
    img_origin = cv2.imread('lena.png', cv2.IMREAD_COLOR)
    img = cv2.imread('lena.png', cv2.IMREAD_COLOR)
    print(img.size)
    print(img.shape)

    hacker(img)

    print('显示图片，请按任意键退出')
    numpy_horizontal_concat = np.concatenate((img_origin, img), axis=1)
    cv2.imshow('Lena图片黑客帝国化', numpy_horizontal_concat)
    cv2.waitKey()
    cv2.destroyAllWindows()

```

## 答案

```python
def hacker(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img.item((i, j))
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img.itemset((i, j), (hack_b, hack_g, hack_r))
```

## 选项

### item+itemset

```python
def hacker(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b,g,r = img.item((i, j, 0)),img.item((i, j, 1)), img.item((i, j, 2))
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img.itemset((i, j, 0), hack_b)
            img.itemset((i, j, 1), hack_g)
            img.itemset((i, j, 2), hack_r)
```

### 直接读取像素

```python
def hacker(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img[i, j]
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img[i, j] = (hack_b, hack_g, hack_r)
```

### 下标访问到通道

```python
def hacker(img):
    height, width, channels = img.shape
    for i in range(0, width):
        for j in range(0, height):
            b, g, r = img[i, j]
            hack_b = int(math.pow(b/256.0, 3/2) * 256)
            hack_g = int(math.pow(g/256.0, 4/5) * 256)
            hack_r = int(math.pow(r/256.0, 3/2) * 256)
            img[i, j, 0] = hack_b
            img[i, j, 1] = hack_g
            img[i, j, 2] = hack_r
```
