import numpy as np
import cv2

if __name__ == '__main__':
    flower = cv2.imread('flower.jpeg', -1)
    hsv = cv2.cvtColor(flower, cv2.COLOR_BGR2HSV)

    lower_red = np.array([0, 20, 100])
    upper_red = np.array([10, 255, 255])

    mask = cv2.inRange(hsv, lower_red, upper_red)
    res = cv2.bitwise_and(flower, flower, mask=mask)

    images = np.concatenate((flower, res), axis=1)
    # cv2.imwrite('flower_only.jpeg', images)
    cv2.imshow('flower', images)
    cv2.waitKey()
    cv2.destroyAllWindows()
