import numpy as np
import cv2

if __name__ == '__main__':
    low_confidence = 0.5
    image_path = '2.jpg'
    proto_txt = 'deploy.proto.txt'
    model_path = 'res10_300x300_ssd_iter_140000_fp16.caffemodel'
    # 加载模型
    print("[INFO] loading model...")
    net = cv2.dnn.readNetFromCaffe(proto_txt, model_path)
    # 加载输入图像并为图像构建一个输入 blob
    # 将大小调整为固定的 300x300 像素，然后对其进行标准化
    image = cv2.imread(image_path)
    (h, w) = image.shape[:2]
    blob = cv2.dnn.blobFromImage(cv2.resize(image, (300, 300)), 1.0,
                                 (300, 300), (104.0, 177.0, 123.0))
    # 通过网络传递blob并获得检测和预测
    print("[INFO] computing object detections...")
    net.setInput(blob)
    detections = net.forward()
    # 循环检测
    for i in range(0, detections.shape[2]):
        # 提取与相关的置信度（即概率）
        # 预测
        confidence = detections[0, 0, i, 2]
        # 通过确保“置信度”来过滤掉弱检测
        # 大于最小置信度
        if confidence > low_confidence:
            # 计算边界框的 (x, y) 坐标
            box = detections[0, 0, i, 3:7] * np.array([w, h, w, h])
            (startX, startY, endX, endY) = box.astype("int")
            # 绘制人脸的边界框以及概率
            text = "{:.2f}%".format(confidence * 100)
            y = startY - 10 if startY - 10 > 10 else startY + 10
            cv2.rectangle(image, (startX, startY), (endX, endY),
                          (0, 0, 255), 2)
            cv2.putText(image, text, (startX, y),
                        cv2.FONT_HERSHEY_SIMPLEX, 0.45, (0, 0, 255), 2)
    # 展示图片并保存
    cv2.imshow("Output", image)
    cv2.imwrite("01.jpg", image)
    cv2.waitKey(0)
