import cv2
import numpy as np
import matplotlib.pyplot as plt


def close_op(img):
    kernel = np.ones((3, 3), np.uint8)
    img1 = cv2.dilate(img, kernel, iterations=1)
    img2 = cv2.erode(img1, kernel, iterations=1)
    return img2


def show_images(images):
    i = 0
    for title in images:
        plt.subplot(2, 3, i+1), plt.imshow(images[title], 'gray')
        plt.title(title)
        plt.xticks([]), plt.yticks([])
        i += 1
    plt.show()


if __name__ == '__main__':
    duck_origin = cv2.imread('duck.jpeg', -1)

    duck_box = duck_origin.copy()
    duck_gray = cv2.cvtColor(duck_box, cv2.COLOR_BGR2GRAY)
    duck_gray_with_closed = close_op(duck_gray)
    ret, duck_binary = cv2.threshold(
        duck_gray_with_closed, 127, 255, cv2.THRESH_BINARY)

    ret, labels, stats, centroid = cv2.connectedComponentsWithStats(
        duck_binary)
    duck_area = sorted(stats, key=lambda s: s[-1], reverse=False)[-2]
    cv2.rectangle(
        duck_box,
        (duck_area[0], duck_area[1]),
        (duck_area[0] + duck_area[2], duck_area[1] + duck_area[3]),
        (255, 0, 0),
        3
    )

    images = {
        'duck_origin': duck_origin,
        'duck_gray': duck_gray,
        'duck_gray_with_closed_op': duck_gray_with_closed,
        'duck_binary': duck_binary,
        'duck_box': duck_box
    }
    show_images(images)
