# 生成列

Joe 需要为 Points 表

```sql
create table points(
    id int primary key auto_increment,
    x float,
    y float
)
```

增加一个生成列，保存每个点的模（modulus），即 `√(x^2 + y^2)` 。下面哪个操作是正确的？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
alter table points add modulus double generated always as (sqrt(x*x + y*y));
```

## 选项

### A

```sql
create generated modulus on table points as (sqrt(x*x + y*y));
```

### B

```sql
alter table points add modulus generated always as (sqrt(x*x + y*y));
```

### C

```sql
alter table points add modulus float generated sqrt(x*x + y*y);
```
