# WHILE

交易过程 trade 中有一个遍历交易项的循环，当累计的总交易额 `@total_price` 超过 20000， 这个循环就结束

```sql
-- ...
trade: LOOP
    -- ... 
    if @total_price > 20000 then
        LEAVE trade;
    else
        ITERATE trade;
    end if;
    -- ...
end LOOP trace;
```

现在 Joe 想要用 `WHILE` 简化这个 `LOOP` 循环，他应该怎么做？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
trade: WHILE @total_price > 20000
    -- 省略交易过程
END WHILE trade;
```

## 选项

### A

```sql
trade: DO 
    -- 省略交易过程
WHILE @total_price > 20000;
```

### B

```sql
trade: WHILE @total_price > 20000
    -- 省略交易过程
END WHILE trade;
```

### C

```sql
trade: WHILE @total_price > 20000 DO
    -- 省略交易过程
END WHILE trade;
```

### D

```sql
trade: WHILE @total_price > 20000
    -- 省略交易过程
END WHILE;
```
