# 积分累计

现有一个表

```sql
create table book_in(
    login integer primary key ,
    score integer default 0
);
```

用于记录用户行为积分，不同的客户端分布式的异步提交各个login的行为得分，如果一个用户不在表中，我们
需要插入一条新纪录，如果已经存在，则需要将新提交的score累加到表中，下列哪个查询可以实现此功能？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
insert into book_in(login, score) values ($1, $2) on DUPLICATE KEY update score=$2;
```

## 选项

### A

```sql
try
    insert into book_in(login, score) values ($1, $2);
catch
    update book_in set score = $2 where login = $1
finally
    commit;
```

### B

```sql
insert into book_in(login, score) select $1, $2;
```

### C

```sql
replace book_in(login, score) select $1, $2;
```

### D

```sql
upsert into book_in(login, score) select $1, $2;
```
