# 隐藏索引

Shop 表的部分字段如下：

```sql
create table shop (
    id int primary key auto_increment,
    description varchar(8000),
    fulltext (description)
      -- ...
)
```

已知 description 字段上的全文索引名为 description。因为这个表已经很大，Joe 
想要删掉这个索引，但是他不确定是否有程序还在使用它，

Joe 应该怎么做？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

先执行

```sql
alter table shop alter index description invisible ;
```

将索引隐藏，观察确认没有影响后再执行

```sql
alter table shop drop index description;
```

删除。


## 选项

### A

先备份 shop 表，然后执行

```sql
alter table shop drop index description;
```
删除，有问题的话从备份文件恢复。

### B

备份 shop ，然后删除重建，重建时去掉 description 相关的索引逻辑。

### C

先执行

```sql
alter table shop alter index description invisible ;
```

将索引隐藏，确认后再执行

```sql
alter table shop alter index description visible ;
```

恢复索引可见。