# 全文索引

Shop 表的部分字段如下：

```sql
create table shop (
    id int primary key auto_increment,
    description varchar(8000)
      -- ...
)
```

现在 Joe 要给 description 字段加上全文索引，他应该怎么做？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
alter table shop add fulltext(description);
```

## 选项

### A

```sql
alter table shop add index fulltext(description);
```

### B

```sql
alter table shop create fulltext(description);
```

### C

```sql
alter table shop alter description add fulltext(description);
```