# 几何索引

Goods 数据库中有一个 shop 表，其中包含如下字段：

```sql
create table shop (
    id int primary key auto_increment,
    location GEOMETRY
      -- ...
)
```

现在 Joe 要给 location 字段加上几何索引，他应该怎么做？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
alter table shop modify location  GEOMETRY not null;
alter table shop add INDEX geo_index(location);
```

## 选项

### A

```sql
alter table shop add INDEX geo_index(location);
```

### B

```sql
alter table shop add INDEX location;
```

### C

```sql
alter table shop modify location  GEOMETRY not null;
alter table shop add INDEX location;
```

### D

```sql
alter table shop modify location  GEOMETRY not null;
alter table shop add INDEX location;
```
