# 唯一约束

Goods 表结构如下：

```sql
create table goods(
    id int primary key auto_increment,
    category_id int,
    name varchar(256),
    price decimal(12, 4),
    stock int,
    upper_time timestamp
)
```

Joe 需要确保同一个类型下没有重名的商品，他应该怎么做？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
alter table goods add unique index (category_id, name);
```

## 选项

### A

```sql
alter table goods add index (category_id, name);
```

### B

```sql
alter table goods add unique index (category_id + name);
```

### C

```sql
alter table goods add unique index (concat(category_id, name));
```
