# 编码转换

Joe 需要将下面这个查询

```sql
select name from goods;
```

中的 name 字段的字符集改为 gb 18030，他应该怎么做？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

##  答案

```sql
select convert(name using 'gb18030') from goods;
```

## 选项


### A

```sql
select str(name, 'gb18303') from goods;
```


### B

```sql
select encode(decode(name, 'utf8mb4'), 'gb18303') from goods;
```


### C

```sql
select convert(name from 'utf8mb4' to 'gb18303') from goods;
```

### D

```sql
select convert(name to 'gb18303') from goods;
```

### E

所有都错