# Union

现有员工信息表和顾客信息表如下

```sql
create table employee(
    id int primary key auto_increment,
    name varchar(256),
    address varchar(1024),
    dept varchar(64)
    -- ignore more
);

create table customer(
                         id int primary key auto_increment,
                         name varchar(256),
                         address varchar(1024),
                         level int
    -- ignore more
)

```

Joe 需要员工和顾客的联系方式（姓名+地址）清单，用于邮寄礼品。这个查询如何写？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select name, address 
from customer
union
select name, address
from employee
```

## 选项

### A

```sql
select * 
from customer
union
select *
from employee
```

### B

```sql
select * 
from customer
join employee
```

### C

```sql
select * 
from customer
join employee on customer.id = employee.id
```

### D

```sql
select * 
from customer, employee
```

### E

```sql
select name, address 
from customer, employee
```

