# 限制用户使用资源

Joe 需要限制数据分析组（role analysis）的用户, 每小时查询次数不能超过10000次。应该怎么操作？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
alter user analysis with MAX_QUERIES_PER_HOUR 10000;
```

## 选项

### A

```sql
set user analysis with MAX_QUERIES_PER_HOUR 10000;
```


### B

```sql
alter role analysis with MAX_QUERIES_PER_HOUR 10000;
```

### C

```sql
alter role analysis with MAX_QUERIES_PER_HOUR=10000;
```

### D

```sql
alter user analysis set MAX_QUERIES_PER_HOUR 10000;
```
