# 数值计算

Points 表结构如下：

```sql
create table points(
    id int primary key auto_increment,
    x float,
    y float
)
```

现在 Joe 想要求写一个查询，得到每个点的id和模。即 √(x^2+y^2) 。这个查询应该是：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select id, sqrt(x^2 + y^2) from points;
```

## 选项

### A

```sql
select sqrt(vx+vy) from (select x^2 as vx, y^2 as vy from points) as t;
```

### B

```sql
select sqrt(vx + vy) from points where x^2 as vx, y^2 as vy ;
```

### C

```sql
select id + sqrt(x^2 + y^2) from points;
```

### D

```sql
select id || sqrt(x^2 + y^2) from points;
```