# 更新数据

现有 employee 表如下：

```sql
create table employee
(
    id serial primary key,
    name varchar(64),
    dept varchar(64),
    salary decimal(12, 4)
);
```

Joe 希望修改销售部(dept 字段为 sale)员工 Dora Muk 的工资，将其增加 1000。正确的修改语句是：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
update employee set salary = salary + 1000 where dept = 'sale' and name = 'Dora Muk';
```

## 选项

### 过滤条件不严谨

```sql
update employee set salary = salary + 1000 where name = 'Dora Muk';
```


### 缺少过滤条件

```sql
update employee set salary = salary + 1000;
```

### 错误的赋值语句

```sql
update employee set salary += 1000;
```

