# 存储引擎

Joe 需要确保 goods_category 表的存储引擎为 innodb ，那么建表语句应该是：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```mysql
CREATE TABLE goods_category
(
    id         INT,
    category VARCHAR(30),
    remark   VARCHAR(100)
) ENGINE=INNODB;
```

## 选项

### A

```mysql
CREATE TABLE goods_category
(
    id         INT,
    category VARCHAR(30),
    remark   VARCHAR(100)
) as INNODB;
```

### B

```mysql
WITH ENGINE=INNODB CREATE TABLE goods_category
(
    id         INT,
    category VARCHAR(30),
    remark   VARCHAR(100)
);
```

### C

```mysql
SAVE TABLE goods_category
(
    id         INT,
    category VARCHAR(30),
    remark   VARCHAR(100)
) AS INNODB;
```

### D

```mysql
CREATE TABLE goods_category
(
    id         INT,
    category VARCHAR(30),
    remark   VARCHAR(100)
) INNODB;
```

