'''
@File    :   utils.py
@Time    :   2022/05/25 15:54:19
@Author  :   Lu Xin 
@Contact :   luxin@csdn.net
'''

# here put the import lib
import json
import logging
import requests

logger = logging.getLogger(__name__)


def load_json(path):
    """ load_json(path:str)->jsObject
    从指定文件读取内容，解析为 json 返回
    @param path: 文件路径
    @return: 解析后的 json
    """
    with open(path) as f:
        data = f.read()
        return json.loads(data)


def dump_json(path, data):
    """ dump_json(path:str, data:obj)->None
    从指定文件读取内容，解析为 json 返回
    @param path: 文件路径
    @param data: json 对象
    @return: None
    """
    with open(path, "w+") as df:
        df.write(json.dumps(data, indent=2, ensure_ascii=False))


def load_markdown(path):
    data = []
    with open(path, "r", encoding="utf-8") as f:
        for line in f.readlines():
            line = line.strip()
            if line == "":
                continue

            data.append(line)

    return data

def write_markdwon(path, data):
    with open(path, "w", encoding='utf-8') as f:
        for line in data:
            f.write(line)


def post_request(url, params, retry=3, headers=None, json_api=True, timeout=20):
    if headers is None:
        hdrs = {"Content-Type": "application/json"}
    else:
        hdrs = headers
    fails = 0
    while fails < retry:
        try:
            if headers is None:
                data = json.dumps(params)
            else:
                data = params
            logger.debug(f"will post {data} to {url}")
            resp = requests.post(url, data, headers=hdrs, timeout=timeout)
            if resp:
                logger.info(f"resp {resp.content}")
                if json_api:
                    return resp.json()
                else:
                    return resp.content
            else:
                logger.error(f"resp: [{resp.status_code}] {resp.content}")
                fails += 1
        except Exception as error:
            logger.error(f"post {params} to {url} failed {error}")
            fails += 1
            if fails > retry:
                raise error


def get_request(url, params, retry=3, json_api=True):
    fails = 0
    while fails < retry:
        try:
            logger.debug(f"will get {params} from {url}")
            resp = requests.get(url, params, timeout=10)
            if resp:
                logger.info(f"resp {resp.content}")
                if json_api:
                    return resp.json()
                else:
                    return resp.content
            else:
                logger.error("resp: None")

        except Exception as error:
            logger.error(f"get {params} from {url} failed {error}")
            fails += 1
            if fails > retry:
                raise error