# 从链式复制到主从复制

Joe实现了一个链式复制架构，standby 是 trade 的从库，backup 是 standby 的从库。
现在，Joe 需要将 backup 修改为 trade 的从节点，实现一对多的主从复制。

他应该如何操作？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

1. 在 trade 服务器上建立用于 backup 访问的复制账户，授予复制权限 `GRANT REPLICATION SLAVE ON *.* TO 'user'@'bakcup';`
2. 在 standby 服务器上执行 `STOP SLAVE;`，停止复制
3. 在 standby 服务器执行 `SHOW MASTER STATUS;`，记录 binlog 文件和 position。
4. 在 backup 上执行 `SHOW SLAVE STATUS;`，确认复制进度与 standby 同步
5. 在 standby 上执行 `SHOW SLAVE STATUS` ，查看来自 trade 的同步进度，记录 `Relay_Master_Log_File` 和 `Exec_Master_Log_Pos`
6. 在 backup 上执行 `STOP SLAVE;` 停止复制，重新设置复制设定，将主服务器相关配置指向 trade
7. 在 standby 上执行 `START SLAVE;` 启动同步
8. 在 backup 上执行 `START SLAVE;` 启动同步

## 选项

### A

1. 在 standby 服务器上执行 `STOP SLAVE;`，停止复制
2. 在 standby 服务器执行 `SHOW MASTER STATUS;`，记录 binlog 文件和 position。
3. 在 backup 上执行 `SHOW SLAVE STATUS;`，确认复制进度与 standby 同步
4. 在 standby 上执行 `SHOW SLAVE STATUS` ，查看来自 trade 的同步进度，记录 `Relay_Master_Log_File` 和 `Exec_Master_Log_Pos`
5. 在 backup 上执行 `STOP SLAVE;` 停止复制，重新设置复制设定，将主服务器相关配置指向 trade
6. 在 standby 上执行 `START SLAVE;` 启动同步
7. 在 backup 上执行 `START SLAVE;` 启动同步

### B

1. 在 trade 服务器上建立用于 backup 访问的复制账户，授予复制权限 `GRANT REPLICATION SLAVE ON *.* TO 'user'@'bakcup';`
2. 在 standby 服务器上执行 `STOP SLAVE;`，停止复制
3. 在 standby 服务器执行 `SHOW MASTER STATUS;`，记录 binlog 文件和 position。
4. 在 backup 上执行 `SHOW SLAVE STATUS;`，确认复制进度与 standby 同步
5. 在 standby 上执行 `SHOW SLAVE STATUS` ，查看来自 trade 的同步进度，记录 `Relay_Master_Log_File` 和 `Exec_Master_Log_Pos`
6. 在 backup 上执行 `STOP SLAVE;` 停止复制，重新设置复制设定，将主服务器相关配置指向 trade
7. 在 standby 上执行 `START SLAVE;` 启动同步
8. 在 backup 上执行 `START SLAVE;` 启动同步
9. 在 trade 上执行 `START MASTER;` 启动同步


### C

所有选项都不对。